/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.input;

import java.util.List;
import mezz.jei.common.input.ICharTypedHandler;
import mezz.jei.common.input.IKeyBindings;
import mezz.jei.common.input.UserInput;
import mezz.jei.common.input.handlers.CombinedInputHandler;
import mezz.jei.core.util.ReflectionUtil;
import net.minecraft.class_342;
import net.minecraft.class_437;

public class ClientInputHandler {
    private final List<ICharTypedHandler> charTypedHandlers;
    private final CombinedInputHandler inputHandler;
    private final IKeyBindings keybindings;
    private final ReflectionUtil reflectionUtil = new ReflectionUtil();

    public ClientInputHandler(List<ICharTypedHandler> charTypedHandlers, CombinedInputHandler inputHandler, IKeyBindings keybindings) {
        this.charTypedHandlers = charTypedHandlers;
        this.inputHandler = inputHandler;
        this.keybindings = keybindings;
    }

    public void onInitGui() {
        this.inputHandler.handleGuiChange();
    }

    public boolean onKeyboardKeyPressedPre(class_437 screen, UserInput input) {
        if (!this.isContainerTextFieldFocused(screen)) {
            return this.inputHandler.handleUserInput(screen, input, this.keybindings).isPresent();
        }
        return false;
    }

    public boolean onKeyboardKeyPressedPost(class_437 screen, UserInput input) {
        if (this.isContainerTextFieldFocused(screen)) {
            return this.inputHandler.handleUserInput(screen, input, this.keybindings).isPresent();
        }
        return false;
    }

    public boolean onKeyboardCharTypedPre(class_437 screen, char codePoint, int modifiers) {
        if (!this.isContainerTextFieldFocused(screen)) {
            return this.handleCharTyped(codePoint, modifiers);
        }
        return false;
    }

    public boolean onKeyboardCharTypedPost(class_437 screen, char codePoint, int modifiers) {
        if (this.isContainerTextFieldFocused(screen)) {
            return this.handleCharTyped(codePoint, modifiers);
        }
        return false;
    }

    public boolean onGuiMouseClicked(class_437 screen, UserInput input) {
        boolean handled = this.inputHandler.handleUserInput(screen, input, this.keybindings).isPresent();
        if (input.is(this.keybindings.getLeftClick())) {
            handled |= this.inputHandler.handleDragStart(screen, input).isPresent();
        }
        return handled;
    }

    public boolean onGuiMouseReleased(class_437 screen, UserInput input) {
        boolean handled = this.inputHandler.handleUserInput(screen, input, this.keybindings).isPresent();
        if (input.is(this.keybindings.getLeftClick())) {
            handled |= this.inputHandler.handleDragComplete(screen, input).isPresent();
        }
        return handled;
    }

    public boolean onGuiMouseScroll(double mouseX, double mouseY, double scrollDelta) {
        return this.inputHandler.handleMouseScrolled(mouseX, mouseY, scrollDelta);
    }

    private boolean handleCharTyped(char codePoint, int modifiers) {
        return this.charTypedHandlers.stream().filter(ICharTypedHandler::hasKeyboardFocus).anyMatch(handler -> handler.onCharTyped(codePoint, modifiers));
    }

    private boolean isContainerTextFieldFocused(class_437 screen) {
        return this.reflectionUtil.getFieldWithClass(screen, class_342.class).anyMatch(textField -> textField.method_37303() && textField.method_25370());
    }
}

